#include <stdlib.h>
#include <assert.h>
#include "mesh.h"
#include "triangle.h"
#include "cvect.h"

mesh::mesh(void) {
  head = cursor = NULL;
  meshsize = 0;
}

void mesh::add(
    double x1, double y1, double z1,
    double x2, double y2, double z2,
    double x3, double y3, double z3
) {
  cvect v1, v2, v3;
  triangle * tp;
  v1[0] = x1; v1[1] = y1; v1[2] = z1;
  v2[0] = x2; v2[1] = y2; v2[2] = z2;
  v3[0] = x3; v3[1] = y3; v3[2] = z3;
  tp = new triangle(v1,v2,v3);
  rewind();
  if (size() > 0) do {
    tp->link(cursor);
  } while (next() && tp->exposed());
  tp->next = head;
  head = tp;
  meshsize++;
}

int mesh::size(void) {
  return meshsize;
}

void mesh::dump(FILE * fp) {
  assert(fp != NULL);
  rewind();
  if (size() > 0) do {
    fprintf(
      fp,
      "    triangle {\n      <%f,%f,%f>,\n      <%f,%f,%f>,\n      <%f,%f,%f>\n    }\n",
      cursor->corner[0][0],
      cursor->corner[0][1],
      cursor->corner[0][2],
      cursor->corner[1][0],
      cursor->corner[1][1],
      cursor->corner[1][2],
      cursor->corner[2][0],
      cursor->corner[2][1],
      cursor->corner[2][2]
    );
  } while (next());
}

void mesh::clear(void) {
  if (head == NULL)
    return;
  delete head;
  head = cursor = NULL;
  meshsize = 0;
}

void mesh::invert(void) {
  if (head == NULL)
    return;
  head->flip(0);
}

mesh::~mesh(void) {
  clear();
}

bool mesh::next(void) {
  if (cursor->next == NULL)
    return false;
  cursor = cursor->next;
  return true;
}

void mesh::rewind(void) {
  cursor = head;
}